/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorFullBayes;
import weka.classifiers.bayes.net.search.local.K2;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;

public class MultiNomialBMAEstimator
extends BayesNetEstimator {
    static final long serialVersionUID = 8330705772601586313L;
    protected boolean m_bUseK2Prior = true;

    @Override
    public String globalInfo() {
        return "Multinomial BMA Estimator.";
    }

    @Override
    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        int iAttribute;
        this.initCPTs(bayesNet);
        int iAttribute2 = 0;
        while (iAttribute2 < bayesNet.m_Instances.numAttributes()) {
            if (bayesNet.getParentSet(iAttribute2).getNrOfParents() > 1) {
                throw new Exception("Cannot handle networks with nodes with more than 1 parent (yet).");
            }
            ++iAttribute2;
        }
        Instances instances = new Instances(bayesNet.m_Instances);
        while (instances.numInstances() > 0) {
            instances.delete(0);
        }
        int iAttribute3 = instances.numAttributes() - 1;
        while (iAttribute3 >= 0) {
            if (iAttribute3 != instances.classIndex()) {
                FastVector<String> values = new FastVector<String>();
                values.addElement("0");
                values.addElement("1");
                Attribute a = new Attribute(instances.attribute(iAttribute3).name(), values);
                instances.deleteAttributeAt(iAttribute3);
                instances.insertAttributeAt(a, iAttribute3);
            }
            --iAttribute3;
        }
        int iInstance = 0;
        while (iInstance < bayesNet.m_Instances.numInstances()) {
            Instance instanceOrig = bayesNet.m_Instances.instance(iInstance);
            DenseInstance instance = new DenseInstance(instances.numAttributes());
            iAttribute = 0;
            while (iAttribute < instances.numAttributes()) {
                if (iAttribute != instances.classIndex()) {
                    if (instanceOrig.value(iAttribute) > 0.0) {
                        instance.setValue(iAttribute, 1.0);
                    }
                } else {
                    instance.setValue(iAttribute, instanceOrig.value(iAttribute));
                }
                ++iAttribute;
            }
            ++iInstance;
        }
        BayesNet EmptyNet = new BayesNet();
        K2 oSearchAlgorithm = new K2();
        oSearchAlgorithm.setInitAsNaiveBayes(false);
        oSearchAlgorithm.setMaxNrOfParents(0);
        EmptyNet.setSearchAlgorithm(oSearchAlgorithm);
        EmptyNet.buildClassifier(instances);
        BayesNet NBNet = new BayesNet();
        oSearchAlgorithm.setInitAsNaiveBayes(true);
        oSearchAlgorithm.setMaxNrOfParents(1);
        NBNet.setSearchAlgorithm(oSearchAlgorithm);
        NBNet.buildClassifier(instances);
        iAttribute = 0;
        while (iAttribute < instances.numAttributes()) {
            if (iAttribute != instances.classIndex()) {
                int iParent;
                int iAttValue;
                double w1 = 0.0;
                double w2 = 0.0;
                int nAttValues = instances.attribute(iAttribute).numValues();
                if (this.m_bUseK2Prior) {
                    iAttValue = 0;
                    while (iAttValue < nAttValues) {
                        w1 += Statistics.lnGamma(1.0 + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0);
                        ++iAttValue;
                    }
                    w1 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + instances.numInstances());
                    iParent = 0;
                    while (iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents()) {
                        int nTotal = 0;
                        int iAttValue2 = 0;
                        while (iAttValue2 < nAttValues) {
                            double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent]).getCount(iAttValue2);
                            w2 += Statistics.lnGamma(1.0 + nCount) - Statistics.lnGamma(1.0);
                            nTotal = (int)((double)nTotal + nCount);
                            ++iAttValue2;
                        }
                        w2 += Statistics.lnGamma(nAttValues) - Statistics.lnGamma(nAttValues + nTotal);
                        ++iParent;
                    }
                } else {
                    iAttValue = 0;
                    while (iAttValue < nAttValues) {
                        w1 += Statistics.lnGamma(1.0 / (double)nAttValues + ((DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0]).getCount(iAttValue)) - Statistics.lnGamma(1.0 / (double)nAttValues);
                        ++iAttValue;
                    }
                    w1 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + instances.numInstances());
                    int nParentValues = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
                    int iParent2 = 0;
                    while (iParent2 < nParentValues) {
                        int nTotal = 0;
                        int iAttValue3 = 0;
                        while (iAttValue3 < nAttValues) {
                            double nCount = ((DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent2]).getCount(iAttValue3);
                            w2 += Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues) + nCount) - Statistics.lnGamma(1.0 / (double)(nAttValues * nParentValues));
                            nTotal = (int)((double)nTotal + nCount);
                            ++iAttValue3;
                        }
                        w2 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + nTotal);
                        ++iParent2;
                    }
                }
                if (w1 < w2) {
                    w2 -= w1;
                    w1 = 0.0;
                    w1 = 1.0 / (1.0 + Math.exp(w2));
                    w2 = Math.exp(w2) / (1.0 + Math.exp(w2));
                } else {
                    w1 -= w2;
                    w2 = 0.0;
                    w2 = 1.0 / (1.0 + Math.exp(w1));
                    w1 = Math.exp(w1) / (1.0 + Math.exp(w1));
                }
                iParent = 0;
                while (iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents()) {
                    bayesNet.m_Distributions[iAttribute][iParent] = new DiscreteEstimatorFullBayes(instances.attribute(iAttribute).numValues(), w1, w2, (DiscreteEstimatorBayes)EmptyNet.m_Distributions[iAttribute][0], (DiscreteEstimatorBayes)NBNet.m_Distributions[iAttribute][iParent], this.m_fAlpha);
                    ++iParent;
                }
            }
            ++iAttribute;
        }
        iAttribute = instances.classIndex();
        bayesNet.m_Distributions[iAttribute][0] = EmptyNet.m_Distributions[iAttribute][0];
    }

    @Override
    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("updateClassifier does not apply to BMA estimator");
    }

    @Override
    public void initCPTs(BayesNet bayesNet) throws Exception {
        bayesNet.m_Distributions = new Estimator[bayesNet.m_Instances.numAttributes()][2];
    }

    public boolean isUseK2Prior() {
        return this.m_bUseK2Prior;
    }

    public void setUseK2Prior(boolean bUseK2Prior) {
        this.m_bUseK2Prior = bUseK2Prior;
    }

    @Override
    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        Instances instances = bayesNet.m_Instances;
        int nNumClasses = instances.numClasses();
        double[] fProbs = new double[nNumClasses];
        int iClass = 0;
        while (iClass < nNumClasses) {
            fProbs[iClass] = 1.0;
            ++iClass;
        }
        iClass = 0;
        while (iClass < nNumClasses) {
            double logfP = 0.0;
            int iAttribute = 0;
            while (iAttribute < instances.numAttributes()) {
                double iCPT = 0.0;
                int iParent = 0;
                while (iParent < bayesNet.getParentSet(iAttribute).getNrOfParents()) {
                    int nParent = bayesNet.getParentSet(iAttribute).getParent(iParent);
                    iCPT = nParent == instances.classIndex() ? iCPT * (double)nNumClasses + (double)iClass : iCPT * (double)instances.attribute(nParent).numValues() + instance.value(nParent);
                    ++iParent;
                }
                logfP = iAttribute == instances.classIndex() ? (logfP += Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(iClass))) : (logfP += instance.value(iAttribute) * Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(instance.value(1))));
                ++iAttribute;
            }
            int n = iClass++;
            fProbs[n] = fProbs[n] + logfP;
        }
        double fMax = fProbs[0];
        int iClass2 = 0;
        while (iClass2 < nNumClasses) {
            if (fProbs[iClass2] > fMax) {
                fMax = fProbs[iClass2];
            }
            ++iClass2;
        }
        iClass2 = 0;
        while (iClass2 < nNumClasses) {
            fProbs[iClass2] = Math.exp(fProbs[iClass2] - fMax);
            ++iClass2;
        }
        Utils.normalize(fProbs);
        return fProbs;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tWhether to use K2 prior.\n", "k2", 0, "-k2"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setUseK2Prior(Utils.getFlag("k2", options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[1 + superOptions.length];
        int current = 0;
        if (this.isUseK2Prior()) {
            options[current++] = "-k2";
        }
        int iOption = 0;
        while (iOption < superOptions.length) {
            options[current++] = superOptions[iOption];
            ++iOption;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

